from mamoth_p3 import *
import os

print("This is a testprogram for the mamoth module. \n")
path = os.getcwd()
try:
    path += "/matrix.txt"
    (MAT, NAMES) = loadmatrix(path, True, verbose=True)
    print("loadmatrix ok \n")
except:
    path = os.getcwd()
    try:    
        path += "\\matrix.txt"
        (MAT, NAMES) = loadmatrix(path, True, verbose=True)
        print("loadmatrix ok \n")
    except:
        print("Testmatrix unavailable - needs to be in same directory as code!")
        raise
    
print("Upper left corner of the matrix:")
print(MAT[0:5, 0:5])
print("\nFirst five statenames:")
print(NAMES[0:5])

AX = histogrid(MAT, visualize=True)
print("histogrid ok \n")

AX2 = histo3d(MAT, visualize=True)
print("histo3d ok \n")

a,b,c = networkplot (MAT, mode=["mp_neighbor"], visualize=True)
print("networkplot ok \n")

d = percolation (MAT, 0, 3, verbose=True)
print("Number of nodes: %s" %(len(d.nodes())))
print("percolation ok \n")

VEC = eigenone (MAT, verbose=True)
print("eigenone ok \n")

(MAT2, EF, PV) = appromatrix (MAT, 0.99, sparse="lil", testing=True, verbose=True)
print("appromatrix ok \n")

#AX3 = histogrid(MAT2, visualize = True)

VEC2 = eigenone (MAT2, verbose=True)
print("eigenone of a sparse matrix ok \n")

(GVAL, PVAL) = testvectors(VEC, VEC2, verbose=True)
print("G, p: %s, %s" %(GVAL, PVAL))
print("testvectors ok \n")


